package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PollForThirdPartyJobsResponse(
    jobs: Option[Iterable[zio.aws.codepipeline.model.ThirdPartyJob]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse = {
    import PollForThirdPartyJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse
      .builder()
      .optionallyWith(
        jobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobs)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly =
    zio.aws.codepipeline.model.PollForThirdPartyJobsResponse
      .wrap(buildAwsValue())
}
object PollForThirdPartyJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PollForThirdPartyJobsResponse =
      zio.aws.codepipeline.model.PollForThirdPartyJobsResponse(
        jobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobs: Option[List[zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly]]
    def getJobs: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly
    ]] = AwsError.unwrapOptionField("jobs", jobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse
  ) extends zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly {
    override val jobs
        : Option[List[zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly]] =
      scala
        .Option(impl.jobs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ThirdPartyJob.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsResponse
  ): zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly =
    new Wrapper(impl)
}
