package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutActionRevisionResponse(
    newRevision: Option[Boolean] = None,
    pipelineExecutionId: Option[PipelineExecutionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse = {
    import PutActionRevisionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse
      .builder()
      .optionallyWith(newRevision.map(value => value: java.lang.Boolean))(
        _.newRevision
      )
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly =
    zio.aws.codepipeline.model.PutActionRevisionResponse.wrap(buildAwsValue())
}
object PutActionRevisionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutActionRevisionResponse =
      zio.aws.codepipeline.model.PutActionRevisionResponse(
        newRevision.map(value => value),
        pipelineExecutionId.map(value => value)
      )
    def newRevision: Option[Boolean]
    def pipelineExecutionId: Option[PipelineExecutionId]
    def getNewRevision: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("newRevision", newRevision)
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse
  ) extends zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly {
    override val newRevision: Option[Boolean] =
      scala.Option(impl.newRevision()).map(value => value: Boolean)
    override val pipelineExecutionId: Option[PipelineExecutionId] = scala
      .Option(impl.pipelineExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutActionRevisionResponse
  ): zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly =
    new Wrapper(impl)
}
