package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StageName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StageDeclaration(
    name: StageName,
    blockers: Option[Iterable[zio.aws.codepipeline.model.BlockerDeclaration]] =
      None,
    actions: Iterable[zio.aws.codepipeline.model.ActionDeclaration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageDeclaration = {
    import StageDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageDeclaration
      .builder()
      .name(StageName.unwrap(name): java.lang.String)
      .optionallyWith(
        blockers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockers)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageDeclaration.ReadOnly =
    zio.aws.codepipeline.model.StageDeclaration.wrap(buildAwsValue())
}
object StageDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageDeclaration =
      zio.aws.codepipeline.model.StageDeclaration(
        name,
        blockers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actions.map { item =>
          item.asEditable
        }
      )
    def name: StageName
    def blockers
        : Option[List[zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly]]
    def actions: List[zio.aws.codepipeline.model.ActionDeclaration.ReadOnly]
    def getName: ZIO[Any, Nothing, StageName] = ZIO.succeed(name)
    def getBlockers: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly
    ]] = AwsError.unwrapOptionField("blockers", blockers)
    def getActions: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.ActionDeclaration.ReadOnly
    ]] = ZIO.succeed(actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageDeclaration
  ) extends zio.aws.codepipeline.model.StageDeclaration.ReadOnly {
    override val name: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.name())
    override val blockers
        : Option[List[zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly]] =
      scala
        .Option(impl.blockers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.BlockerDeclaration.wrap(item)
          }.toList
        )
    override val actions
        : List[zio.aws.codepipeline.model.ActionDeclaration.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.ActionDeclaration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageDeclaration
  ): zio.aws.codepipeline.model.StageDeclaration.ReadOnly = new Wrapper(impl)
}
