package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  DisabledReason,
  LastChangedAt,
  LastChangedBy,
  Enabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TransitionState(
    enabled: Option[Enabled] = None,
    lastChangedBy: Option[LastChangedBy] = None,
    lastChangedAt: Option[LastChangedAt] = None,
    disabledReason: Option[DisabledReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.TransitionState = {
    import TransitionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.TransitionState
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        lastChangedBy.map(value =>
          LastChangedBy.unwrap(value): java.lang.String
        )
      )(_.lastChangedBy)
      .optionallyWith(
        lastChangedAt.map(value => LastChangedAt.unwrap(value): Instant)
      )(_.lastChangedAt)
      .optionallyWith(
        disabledReason.map(value =>
          DisabledReason.unwrap(value): java.lang.String
        )
      )(_.disabledReason)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.TransitionState.ReadOnly =
    zio.aws.codepipeline.model.TransitionState.wrap(buildAwsValue())
}
object TransitionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.TransitionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.TransitionState =
      zio.aws.codepipeline.model.TransitionState(
        enabled.map(value => value),
        lastChangedBy.map(value => value),
        lastChangedAt.map(value => value),
        disabledReason.map(value => value)
      )
    def enabled: Option[Enabled]
    def lastChangedBy: Option[LastChangedBy]
    def lastChangedAt: Option[LastChangedAt]
    def disabledReason: Option[DisabledReason]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLastChangedBy: ZIO[Any, AwsError, LastChangedBy] =
      AwsError.unwrapOptionField("lastChangedBy", lastChangedBy)
    def getLastChangedAt: ZIO[Any, AwsError, LastChangedAt] =
      AwsError.unwrapOptionField("lastChangedAt", lastChangedAt)
    def getDisabledReason: ZIO[Any, AwsError, DisabledReason] =
      AwsError.unwrapOptionField("disabledReason", disabledReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.TransitionState
  ) extends zio.aws.codepipeline.model.TransitionState.ReadOnly {
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.codepipeline.model.primitives.Enabled(value))
    override val lastChangedBy: Option[LastChangedBy] = scala
      .Option(impl.lastChangedBy())
      .map(value => zio.aws.codepipeline.model.primitives.LastChangedBy(value))
    override val lastChangedAt: Option[LastChangedAt] = scala
      .Option(impl.lastChangedAt())
      .map(value => zio.aws.codepipeline.model.primitives.LastChangedAt(value))
    override val disabledReason: Option[DisabledReason] = scala
      .Option(impl.disabledReason())
      .map(value => zio.aws.codepipeline.model.primitives.DisabledReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.TransitionState
  ): zio.aws.codepipeline.model.TransitionState.ReadOnly = new Wrapper(impl)
}
