package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  Percentage,
  ExecutionId,
  ExecutionSummary
}
import scala.jdk.CollectionConverters.*
final case class ExecutionDetails(
    summary: Optional[ExecutionSummary] = Optional.Absent,
    externalExecutionId: Optional[ExecutionId] = Optional.Absent,
    percentComplete: Optional[Percentage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ExecutionDetails = {
    import ExecutionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ExecutionDetails
      .builder()
      .optionallyWith(
        summary.map(value => ExecutionSummary.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(
        externalExecutionId.map(value =>
          ExecutionId.unwrap(value): java.lang.String
        )
      )(_.externalExecutionId)
      .optionallyWith(
        percentComplete.map(value => Percentage.unwrap(value): Integer)
      )(_.percentComplete)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ExecutionDetails.ReadOnly =
    zio.aws.codepipeline.model.ExecutionDetails.wrap(buildAwsValue())
}
object ExecutionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ExecutionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ExecutionDetails =
      zio.aws.codepipeline.model.ExecutionDetails(
        summary.map(value => value),
        externalExecutionId.map(value => value),
        percentComplete.map(value => value)
      )
    def summary: Optional[ExecutionSummary]
    def externalExecutionId: Optional[ExecutionId]
    def percentComplete: Optional[Percentage]
    def getSummary: ZIO[Any, AwsError, ExecutionSummary] =
      AwsError.unwrapOptionField("summary", summary)
    def getExternalExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("externalExecutionId", externalExecutionId)
    def getPercentComplete: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentComplete", percentComplete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutionDetails
  ) extends zio.aws.codepipeline.model.ExecutionDetails.ReadOnly {
    override val summary: Optional[ExecutionSummary] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ExecutionSummary(value)
      )
    override val externalExecutionId: Optional[ExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalExecutionId())
        .map(value => zio.aws.codepipeline.model.primitives.ExecutionId(value))
    override val percentComplete: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.percentComplete())
      .map(value => zio.aws.codepipeline.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutionDetails
  ): zio.aws.codepipeline.model.ExecutionDetails.ReadOnly = new Wrapper(impl)
}
