package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ActionCategory {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ActionCategory
}
object ActionCategory {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ActionCategory
  ): zio.aws.codepipeline.model.ActionCategory = value match {
    case software.amazon.awssdk.services.codepipeline.model.ActionCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionCategory.SOURCE =>
      val r = Source
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionCategory.BUILD =>
      val r = Build
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionCategory.DEPLOY =>
      val r = Deploy
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionCategory.TEST =>
      val r = Test
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionCategory.INVOKE =>
      val r = Invoke
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionCategory.APPROVAL =>
      val r = Approval
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionCategory =
      software.amazon.awssdk.services.codepipeline.model.ActionCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object Source extends zio.aws.codepipeline.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionCategory =
      software.amazon.awssdk.services.codepipeline.model.ActionCategory.SOURCE
  }
  case object Build extends zio.aws.codepipeline.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionCategory =
      software.amazon.awssdk.services.codepipeline.model.ActionCategory.BUILD
  }
  case object Deploy extends zio.aws.codepipeline.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionCategory =
      software.amazon.awssdk.services.codepipeline.model.ActionCategory.DEPLOY
  }
  case object Test extends zio.aws.codepipeline.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionCategory =
      software.amazon.awssdk.services.codepipeline.model.ActionCategory.TEST
  }
  case object Invoke extends zio.aws.codepipeline.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionCategory =
      software.amazon.awssdk.services.codepipeline.model.ActionCategory.INVOKE
  }
  case object Approval extends zio.aws.codepipeline.model.ActionCategory {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionCategory =
      software.amazon.awssdk.services.codepipeline.model.ActionCategory.APPROVAL
  }
}
