package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  ActionExecutionToken,
  Url,
  Percentage,
  Timestamp,
  ActionExecutionId,
  ExecutionId,
  ExecutionSummary,
  LastUpdatedBy
}
import scala.jdk.CollectionConverters.*
final case class ActionExecution(
    actionExecutionId: Optional[ActionExecutionId] = Optional.Absent,
    status: Optional[zio.aws.codepipeline.model.ActionExecutionStatus] =
      Optional.Absent,
    summary: Optional[ExecutionSummary] = Optional.Absent,
    lastStatusChange: Optional[Timestamp] = Optional.Absent,
    token: Optional[ActionExecutionToken] = Optional.Absent,
    lastUpdatedBy: Optional[LastUpdatedBy] = Optional.Absent,
    externalExecutionId: Optional[ExecutionId] = Optional.Absent,
    externalExecutionUrl: Optional[Url] = Optional.Absent,
    percentComplete: Optional[Percentage] = Optional.Absent,
    errorDetails: Optional[zio.aws.codepipeline.model.ErrorDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionExecution = {
    import ActionExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionExecution
      .builder()
      .optionallyWith(
        actionExecutionId.map(value =>
          ActionExecutionId.unwrap(value): java.lang.String
        )
      )(_.actionExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        summary.map(value => ExecutionSummary.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(
        lastStatusChange.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStatusChange)
      .optionallyWith(
        token.map(value => ActionExecutionToken.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        lastUpdatedBy.map(value =>
          LastUpdatedBy.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedBy)
      .optionallyWith(
        externalExecutionId.map(value =>
          ExecutionId.unwrap(value): java.lang.String
        )
      )(_.externalExecutionId)
      .optionallyWith(
        externalExecutionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.externalExecutionUrl)
      .optionallyWith(
        percentComplete.map(value => Percentage.unwrap(value): Integer)
      )(_.percentComplete)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionExecution.ReadOnly =
    zio.aws.codepipeline.model.ActionExecution.wrap(buildAwsValue())
}
object ActionExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionExecution =
      zio.aws.codepipeline.model.ActionExecution(
        actionExecutionId.map(value => value),
        status.map(value => value),
        summary.map(value => value),
        lastStatusChange.map(value => value),
        token.map(value => value),
        lastUpdatedBy.map(value => value),
        externalExecutionId.map(value => value),
        externalExecutionUrl.map(value => value),
        percentComplete.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def actionExecutionId: Optional[ActionExecutionId]
    def status: Optional[zio.aws.codepipeline.model.ActionExecutionStatus]
    def summary: Optional[ExecutionSummary]
    def lastStatusChange: Optional[Timestamp]
    def token: Optional[ActionExecutionToken]
    def lastUpdatedBy: Optional[LastUpdatedBy]
    def externalExecutionId: Optional[ExecutionId]
    def externalExecutionUrl: Optional[Url]
    def percentComplete: Optional[Percentage]
    def errorDetails: Optional[zio.aws.codepipeline.model.ErrorDetails.ReadOnly]
    def getActionExecutionId: ZIO[Any, AwsError, ActionExecutionId] =
      AwsError.unwrapOptionField("actionExecutionId", actionExecutionId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSummary: ZIO[Any, AwsError, ExecutionSummary] =
      AwsError.unwrapOptionField("summary", summary)
    def getLastStatusChange: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
    def getToken: ZIO[Any, AwsError, ActionExecutionToken] =
      AwsError.unwrapOptionField("token", token)
    def getLastUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getExternalExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("externalExecutionId", externalExecutionId)
    def getExternalExecutionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("externalExecutionUrl", externalExecutionUrl)
    def getPercentComplete: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentComplete", percentComplete)
    def getErrorDetails
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecution
  ) extends zio.aws.codepipeline.model.ActionExecution.ReadOnly {
    override val actionExecutionId: Optional[ActionExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ActionExecutionId(value)
        )
    override val status
        : Optional[zio.aws.codepipeline.model.ActionExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codepipeline.model.ActionExecutionStatus.wrap(value)
        )
    override val summary: Optional[ExecutionSummary] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ExecutionSummary(value)
      )
    override val lastStatusChange: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusChange())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val token: Optional[ActionExecutionToken] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ActionExecutionToken(value)
      )
    override val lastUpdatedBy: Optional[LastUpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedBy())
      .map(value => zio.aws.codepipeline.model.primitives.LastUpdatedBy(value))
    override val externalExecutionId: Optional[ExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalExecutionId())
        .map(value => zio.aws.codepipeline.model.primitives.ExecutionId(value))
    override val externalExecutionUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.externalExecutionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val percentComplete: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.percentComplete())
      .map(value => zio.aws.codepipeline.model.primitives.Percentage(value))
    override val errorDetails
        : Optional[zio.aws.codepipeline.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value => zio.aws.codepipeline.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecution
  ): zio.aws.codepipeline.model.ActionExecution.ReadOnly = new Wrapper(impl)
}
