package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PropertyDescription,
  ActionConfigurationKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActionTypeProperty(
    name: ActionConfigurationKey,
    optional: Boolean,
    key: Boolean,
    noEcho: Boolean,
    queryable: Optional[Boolean] = Optional.Absent,
    description: Optional[PropertyDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty = {
    import ActionTypeProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty
      .builder()
      .name(ActionConfigurationKey.unwrap(name): java.lang.String)
      .optional(optional: java.lang.Boolean)
      .key(key: java.lang.Boolean)
      .noEcho(noEcho: java.lang.Boolean)
      .optionallyWith(queryable.map(value => value: java.lang.Boolean))(
        _.queryable
      )
      .optionallyWith(
        description.map(value =>
          PropertyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeProperty.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeProperty.wrap(buildAwsValue())
}
object ActionTypeProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeProperty =
      zio.aws.codepipeline.model.ActionTypeProperty(
        name,
        optional,
        key,
        noEcho,
        queryable.map(value => value),
        description.map(value => value)
      )
    def name: ActionConfigurationKey
    def optional: Boolean
    def key: Boolean
    def noEcho: Boolean
    def queryable: Optional[Boolean]
    def description: Optional[PropertyDescription]
    def getName: ZIO[Any, Nothing, ActionConfigurationKey] = ZIO.succeed(name)
    def getOptional: ZIO[Any, Nothing, Boolean] = ZIO.succeed(optional)
    def getKey: ZIO[Any, Nothing, Boolean] = ZIO.succeed(key)
    def getNoEcho: ZIO[Any, Nothing, Boolean] = ZIO.succeed(noEcho)
    def getQueryable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("queryable", queryable)
    def getDescription: ZIO[Any, AwsError, PropertyDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty
  ) extends zio.aws.codepipeline.model.ActionTypeProperty.ReadOnly {
    override val name: ActionConfigurationKey =
      zio.aws.codepipeline.model.primitives.ActionConfigurationKey(impl.name())
    override val optional: Boolean = impl.optional(): Boolean
    override val key: Boolean = impl.key(): Boolean
    override val noEcho: Boolean = impl.noEcho(): Boolean
    override val queryable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.queryable())
      .map(value => value: Boolean)
    override val description: Optional[PropertyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PropertyDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeProperty
  ): zio.aws.codepipeline.model.ActionTypeProperty.ReadOnly = new Wrapper(impl)
}
