package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutorType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ExecutorType
}
object ExecutorType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ExecutorType
  ): zio.aws.codepipeline.model.ExecutorType = value match {
    case software.amazon.awssdk.services.codepipeline.model.ExecutorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ExecutorType.JOB_WORKER =>
      val r = JobWorker
      r
    case software.amazon.awssdk.services.codepipeline.model.ExecutorType.LAMBDA =>
      val r = Lambda
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ExecutorType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutorType =
      software.amazon.awssdk.services.codepipeline.model.ExecutorType.UNKNOWN_TO_SDK_VERSION
  }
  case object JobWorker extends zio.aws.codepipeline.model.ExecutorType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutorType =
      software.amazon.awssdk.services.codepipeline.model.ExecutorType.JOB_WORKER
  }
  case object Lambda extends zio.aws.codepipeline.model.ExecutorType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutorType =
      software.amazon.awssdk.services.codepipeline.model.ExecutorType.LAMBDA
  }
}
