package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait FailureType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.FailureType
}
object FailureType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.FailureType
  ): zio.aws.codepipeline.model.FailureType = value match {
    case software.amazon.awssdk.services.codepipeline.model.FailureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.FailureType.JOB_FAILED =>
      val r = JobFailed
      r
    case software.amazon.awssdk.services.codepipeline.model.FailureType.CONFIGURATION_ERROR =>
      val r = ConfigurationError
      r
    case software.amazon.awssdk.services.codepipeline.model.FailureType.PERMISSION_ERROR =>
      val r = PermissionError
      r
    case software.amazon.awssdk.services.codepipeline.model.FailureType.REVISION_OUT_OF_SYNC =>
      val r = RevisionOutOfSync
      r
    case software.amazon.awssdk.services.codepipeline.model.FailureType.REVISION_UNAVAILABLE =>
      val r = RevisionUnavailable
      r
    case software.amazon.awssdk.services.codepipeline.model.FailureType.SYSTEM_UNAVAILABLE =>
      val r = SystemUnavailable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.FailureType =
      software.amazon.awssdk.services.codepipeline.model.FailureType.UNKNOWN_TO_SDK_VERSION
  }
  case object JobFailed extends zio.aws.codepipeline.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.FailureType =
      software.amazon.awssdk.services.codepipeline.model.FailureType.JOB_FAILED
  }
  case object ConfigurationError
      extends zio.aws.codepipeline.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.FailureType =
      software.amazon.awssdk.services.codepipeline.model.FailureType.CONFIGURATION_ERROR
  }
  case object PermissionError extends zio.aws.codepipeline.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.FailureType =
      software.amazon.awssdk.services.codepipeline.model.FailureType.PERMISSION_ERROR
  }
  case object RevisionOutOfSync extends zio.aws.codepipeline.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.FailureType =
      software.amazon.awssdk.services.codepipeline.model.FailureType.REVISION_OUT_OF_SYNC
  }
  case object RevisionUnavailable
      extends zio.aws.codepipeline.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.FailureType =
      software.amazon.awssdk.services.codepipeline.model.FailureType.REVISION_UNAVAILABLE
  }
  case object SystemUnavailable extends zio.aws.codepipeline.model.FailureType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.FailureType =
      software.amazon.awssdk.services.codepipeline.model.FailureType.SYSTEM_UNAVAILABLE
  }
}
