package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait StageTransitionType {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.StageTransitionType
}
object StageTransitionType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.StageTransitionType
  ): zio.aws.codepipeline.model.StageTransitionType = value match {
    case software.amazon.awssdk.services.codepipeline.model.StageTransitionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.StageTransitionType.INBOUND =>
      val r = Inbound
      r
    case software.amazon.awssdk.services.codepipeline.model.StageTransitionType.OUTBOUND =>
      val r = Outbound
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.StageTransitionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageTransitionType =
      software.amazon.awssdk.services.codepipeline.model.StageTransitionType.UNKNOWN_TO_SDK_VERSION
  }
  case object Inbound extends zio.aws.codepipeline.model.StageTransitionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageTransitionType =
      software.amazon.awssdk.services.codepipeline.model.StageTransitionType.INBOUND
  }
  case object Outbound extends zio.aws.codepipeline.model.StageTransitionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageTransitionType =
      software.amazon.awssdk.services.codepipeline.model.StageTransitionType.OUTBOUND
  }
}
