package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  WebhookAuthConfigurationSecretToken,
  WebhookAuthConfigurationAllowedIPRange
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WebhookAuthConfiguration(
    allowedIPRange: Optional[WebhookAuthConfigurationAllowedIPRange] =
      Optional.Absent,
    secretToken: Optional[WebhookAuthConfigurationSecretToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.WebhookAuthConfiguration = {
    import WebhookAuthConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.WebhookAuthConfiguration
      .builder()
      .optionallyWith(
        allowedIPRange.map(value =>
          WebhookAuthConfigurationAllowedIPRange.unwrap(value): java.lang.String
        )
      )(_.allowedIPRange)
      .optionallyWith(
        secretToken.map(value =>
          WebhookAuthConfigurationSecretToken.unwrap(value): java.lang.String
        )
      )(_.secretToken)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.WebhookAuthConfiguration.ReadOnly =
    zio.aws.codepipeline.model.WebhookAuthConfiguration.wrap(buildAwsValue())
}
object WebhookAuthConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.WebhookAuthConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.WebhookAuthConfiguration =
      zio.aws.codepipeline.model.WebhookAuthConfiguration(
        allowedIPRange.map(value => value),
        secretToken.map(value => value)
      )
    def allowedIPRange: Optional[WebhookAuthConfigurationAllowedIPRange]
    def secretToken: Optional[WebhookAuthConfigurationSecretToken]
    def getAllowedIPRange
        : ZIO[Any, AwsError, WebhookAuthConfigurationAllowedIPRange] =
      AwsError.unwrapOptionField("allowedIPRange", allowedIPRange)
    def getSecretToken
        : ZIO[Any, AwsError, WebhookAuthConfigurationSecretToken] =
      AwsError.unwrapOptionField("secretToken", secretToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.WebhookAuthConfiguration
  ) extends zio.aws.codepipeline.model.WebhookAuthConfiguration.ReadOnly {
    override val allowedIPRange
        : Optional[WebhookAuthConfigurationAllowedIPRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedIPRange())
        .map(value =>
          zio.aws.codepipeline.model.primitives
            .WebhookAuthConfigurationAllowedIPRange(value)
        )
    override val secretToken: Optional[WebhookAuthConfigurationSecretToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretToken())
        .map(value =>
          zio.aws.codepipeline.model.primitives
            .WebhookAuthConfigurationSecretToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.WebhookAuthConfiguration
  ): zio.aws.codepipeline.model.WebhookAuthConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
