package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{JobId, ClientId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThirdPartyJob(
    clientId: Optional[ClientId] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob = {
    import ThirdPartyJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
      .builder()
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly =
    zio.aws.codepipeline.model.ThirdPartyJob.wrap(buildAwsValue())
}
object ThirdPartyJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ThirdPartyJob =
      zio.aws.codepipeline.model
        .ThirdPartyJob(clientId.map(value => value), jobId.map(value => value))
    def clientId: Optional[ClientId]
    def jobId: Optional[JobId]
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
  ) extends zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly {
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.codepipeline.model.primitives.ClientId(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.codepipeline.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
  ): zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly = new Wrapper(impl)
}
