package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codepipeline.model.primitives.{
  RevisionSummary,
  Time,
  RevisionChangeIdentifier,
  Revision
}
import scala.jdk.CollectionConverters.*
final case class CurrentRevision(
    revision: Revision,
    changeIdentifier: RevisionChangeIdentifier,
    created: Optional[Time] = Optional.Absent,
    revisionSummary: Optional[RevisionSummary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.CurrentRevision = {
    import CurrentRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.CurrentRevision
      .builder()
      .revision(Revision.unwrap(revision): java.lang.String)
      .changeIdentifier(
        RevisionChangeIdentifier.unwrap(changeIdentifier): java.lang.String
      )
      .optionallyWith(created.map(value => Time.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        revisionSummary.map(value =>
          RevisionSummary.unwrap(value): java.lang.String
        )
      )(_.revisionSummary)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.CurrentRevision.ReadOnly =
    zio.aws.codepipeline.model.CurrentRevision.wrap(buildAwsValue())
}
object CurrentRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.CurrentRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.CurrentRevision =
      zio.aws.codepipeline.model.CurrentRevision(
        revision,
        changeIdentifier,
        created.map(value => value),
        revisionSummary.map(value => value)
      )
    def revision: Revision
    def changeIdentifier: RevisionChangeIdentifier
    def created: Optional[Time]
    def revisionSummary: Optional[RevisionSummary]
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
    def getChangeIdentifier: ZIO[Any, Nothing, RevisionChangeIdentifier] =
      ZIO.succeed(changeIdentifier)
    def getCreated: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("created", created)
    def getRevisionSummary: ZIO[Any, AwsError, RevisionSummary] =
      AwsError.unwrapOptionField("revisionSummary", revisionSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.CurrentRevision
  ) extends zio.aws.codepipeline.model.CurrentRevision.ReadOnly {
    override val revision: Revision =
      zio.aws.codepipeline.model.primitives.Revision(impl.revision())
    override val changeIdentifier: RevisionChangeIdentifier =
      zio.aws.codepipeline.model.primitives
        .RevisionChangeIdentifier(impl.changeIdentifier())
    override val created: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Time(value))
    override val revisionSummary: Optional[RevisionSummary] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionSummary())
        .map(value =>
          zio.aws.codepipeline.model.primitives.RevisionSummary(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.CurrentRevision
  ): zio.aws.codepipeline.model.CurrentRevision.ReadOnly = new Wrapper(impl)
}
