package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{PipelineVersion, PipelineName}
import scala.jdk.CollectionConverters.*
final case class GetPipelineRequest(
    name: PipelineName,
    version: Optional[PipelineVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest = {
    import GetPipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest
      .builder()
      .name(PipelineName.unwrap(name): java.lang.String)
      .optionallyWith(
        version.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetPipelineRequest.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineRequest.wrap(buildAwsValue())
}
object GetPipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineRequest =
      zio.aws.codepipeline.model
        .GetPipelineRequest(name, version.map(value => value))
    def name: PipelineName
    def version: Optional[PipelineVersion]
    def getName: ZIO[Any, Nothing, PipelineName] = ZIO.succeed(name)
    def getVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest
  ) extends zio.aws.codepipeline.model.GetPipelineRequest.ReadOnly {
    override val name: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.name())
    override val version: Optional[PipelineVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineRequest
  ): zio.aws.codepipeline.model.GetPipelineRequest.ReadOnly = new Wrapper(impl)
}
