package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.JobStatus
  ): zio.aws.codepipeline.model.JobStatus = value match {
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.CREATED =>
      val r = Created
      r
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.QUEUED =>
      val r = Queued
      r
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.DISPATCHED =>
      val r = Dispatched
      r
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.TIMED_OUT =>
      val r = TimedOut
      r
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codepipeline.model.JobStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Created extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.CREATED
  }
  case object Queued extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.QUEUED
  }
  case object Dispatched extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.DISPATCHED
  }
  case object InProgress extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.IN_PROGRESS
  }
  case object TimedOut extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.TIMED_OUT
  }
  case object Succeeded extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.codepipeline.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.JobStatus =
      software.amazon.awssdk.services.codepipeline.model.JobStatus.FAILED
  }
}
