package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  OutputVariablesValue,
  OutputVariablesKey,
  ContinuationToken,
  JobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutJobSuccessResultRequest(
    jobId: JobId,
    currentRevision: Optional[zio.aws.codepipeline.model.CurrentRevision] =
      Optional.Absent,
    continuationToken: Optional[ContinuationToken] = Optional.Absent,
    executionDetails: Optional[zio.aws.codepipeline.model.ExecutionDetails] =
      Optional.Absent,
    outputVariables: Optional[Map[OutputVariablesKey, OutputVariablesValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest = {
    import PutJobSuccessResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(currentRevision.map(value => value.buildAwsValue()))(
        _.currentRevision
      )
      .optionallyWith(
        continuationToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.continuationToken)
      .optionallyWith(executionDetails.map(value => value.buildAwsValue()))(
        _.executionDetails
      )
      .optionallyWith(
        outputVariables.map(value =>
          value
            .map({ case (key, value) =>
              (OutputVariablesKey
                .unwrap(key): java.lang.String) -> (OutputVariablesValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.outputVariables)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PutJobSuccessResultRequest.ReadOnly =
    zio.aws.codepipeline.model.PutJobSuccessResultRequest.wrap(buildAwsValue())
}
object PutJobSuccessResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutJobSuccessResultRequest =
      zio.aws.codepipeline.model.PutJobSuccessResultRequest(
        jobId,
        currentRevision.map(value => value.asEditable),
        continuationToken.map(value => value),
        executionDetails.map(value => value.asEditable),
        outputVariables.map(value => value)
      )
    def jobId: JobId
    def currentRevision
        : Optional[zio.aws.codepipeline.model.CurrentRevision.ReadOnly]
    def continuationToken: Optional[ContinuationToken]
    def executionDetails
        : Optional[zio.aws.codepipeline.model.ExecutionDetails.ReadOnly]
    def outputVariables: Optional[Map[OutputVariablesKey, OutputVariablesValue]]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getCurrentRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.CurrentRevision.ReadOnly
    ] = AwsError.unwrapOptionField("currentRevision", currentRevision)
    def getContinuationToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getExecutionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ExecutionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("executionDetails", executionDetails)
    def getOutputVariables
        : ZIO[Any, AwsError, Map[OutputVariablesKey, OutputVariablesValue]] =
      AwsError.unwrapOptionField("outputVariables", outputVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
  ) extends zio.aws.codepipeline.model.PutJobSuccessResultRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.codepipeline.model.primitives.JobId(impl.jobId())
    override val currentRevision
        : Optional[zio.aws.codepipeline.model.CurrentRevision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentRevision())
        .map(value => zio.aws.codepipeline.model.CurrentRevision.wrap(value))
    override val continuationToken: Optional[ContinuationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continuationToken())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ContinuationToken(value)
        )
    override val executionDetails
        : Optional[zio.aws.codepipeline.model.ExecutionDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionDetails())
        .map(value => zio.aws.codepipeline.model.ExecutionDetails.wrap(value))
    override val outputVariables
        : Optional[Map[OutputVariablesKey, OutputVariablesValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codepipeline.model.primitives.OutputVariablesKey(
                key
              ) -> zio.aws.codepipeline.model.primitives
                .OutputVariablesValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
  ): zio.aws.codepipeline.model.PutJobSuccessResultRequest.ReadOnly =
    new Wrapper(impl)
}
