package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  MaximumActionTypeArtifactCount,
  MinimumActionTypeArtifactCount
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ActionTypeArtifactDetails(
    minimumCount: MinimumActionTypeArtifactCount,
    maximumCount: MaximumActionTypeArtifactCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeArtifactDetails = {
    import ActionTypeArtifactDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeArtifactDetails
      .builder()
      .minimumCount(
        MinimumActionTypeArtifactCount.unwrap(minimumCount): Integer
      )
      .maximumCount(
        MaximumActionTypeArtifactCount.unwrap(maximumCount): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeArtifactDetails.wrap(buildAwsValue())
}
object ActionTypeArtifactDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeArtifactDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeArtifactDetails =
      zio.aws.codepipeline.model
        .ActionTypeArtifactDetails(minimumCount, maximumCount)
    def minimumCount: MinimumActionTypeArtifactCount
    def maximumCount: MaximumActionTypeArtifactCount
    def getMinimumCount: ZIO[Any, Nothing, MinimumActionTypeArtifactCount] =
      ZIO.succeed(minimumCount)
    def getMaximumCount: ZIO[Any, Nothing, MaximumActionTypeArtifactCount] =
      ZIO.succeed(maximumCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeArtifactDetails
  ) extends zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly {
    override val minimumCount: MinimumActionTypeArtifactCount =
      zio.aws.codepipeline.model.primitives
        .MinimumActionTypeArtifactCount(impl.minimumCount())
    override val maximumCount: MaximumActionTypeArtifactCount =
      zio.aws.codepipeline.model.primitives
        .MaximumActionTypeArtifactCount(impl.maximumCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeArtifactDetails
  ): zio.aws.codepipeline.model.ActionTypeArtifactDetails.ReadOnly =
    new Wrapper(impl)
}
