package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  JobTimeout,
  PolicyStatementsTemplate
}
import scala.jdk.CollectionConverters.*
final case class ActionTypeExecutor(
    configuration: zio.aws.codepipeline.model.ExecutorConfiguration,
    `type`: zio.aws.codepipeline.model.ExecutorType,
    policyStatementsTemplate: Optional[PolicyStatementsTemplate] =
      Optional.Absent,
    jobTimeout: Optional[JobTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor = {
    import ActionTypeExecutor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
      .builder()
      .configuration(configuration.buildAwsValue())
      .`type`(`type`.unwrap)
      .optionallyWith(
        policyStatementsTemplate.map(value =>
          PolicyStatementsTemplate.unwrap(value): java.lang.String
        )
      )(_.policyStatementsTemplate)
      .optionallyWith(
        jobTimeout.map(value => JobTimeout.unwrap(value): Integer)
      )(_.jobTimeout)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeExecutor.wrap(buildAwsValue())
}
object ActionTypeExecutor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeExecutor =
      zio.aws.codepipeline.model.ActionTypeExecutor(
        configuration.asEditable,
        `type`,
        policyStatementsTemplate.map(value => value),
        jobTimeout.map(value => value)
      )
    def configuration: zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly
    def `type`: zio.aws.codepipeline.model.ExecutorType
    def policyStatementsTemplate: Optional[PolicyStatementsTemplate]
    def jobTimeout: Optional[JobTimeout]
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
    def getType: ZIO[Any, Nothing, zio.aws.codepipeline.model.ExecutorType] =
      ZIO.succeed(`type`)
    def getPolicyStatementsTemplate
        : ZIO[Any, AwsError, PolicyStatementsTemplate] = AwsError
      .unwrapOptionField("policyStatementsTemplate", policyStatementsTemplate)
    def getJobTimeout: ZIO[Any, AwsError, JobTimeout] =
      AwsError.unwrapOptionField("jobTimeout", jobTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
  ) extends zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly {
    override val configuration
        : zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly =
      zio.aws.codepipeline.model.ExecutorConfiguration
        .wrap(impl.configuration())
    override val `type`: zio.aws.codepipeline.model.ExecutorType =
      zio.aws.codepipeline.model.ExecutorType.wrap(impl.`type`())
    override val policyStatementsTemplate: Optional[PolicyStatementsTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyStatementsTemplate())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PolicyStatementsTemplate(value)
        )
    override val jobTimeout: Optional[JobTimeout] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTimeout())
      .map(value => zio.aws.codepipeline.model.primitives.JobTimeout(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
  ): zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly = new Wrapper(impl)
}
