package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePipelineRequest(
    pipeline: zio.aws.codepipeline.model.PipelineDeclaration,
    tags: Optional[Iterable[zio.aws.codepipeline.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest = {
    import CreatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest
      .builder()
      .pipeline(pipeline.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.CreatePipelineRequest.ReadOnly =
    zio.aws.codepipeline.model.CreatePipelineRequest.wrap(buildAwsValue())
}
object CreatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.CreatePipelineRequest =
      zio.aws.codepipeline.model.CreatePipelineRequest(
        pipeline.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipeline: zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    def tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]]
    def getPipeline: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    ] = ZIO.succeed(pipeline)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest
  ) extends zio.aws.codepipeline.model.CreatePipelineRequest.ReadOnly {
    override val pipeline
        : zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly =
      zio.aws.codepipeline.model.PipelineDeclaration.wrap(impl.pipeline())
    override val tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.CreatePipelineRequest
  ): zio.aws.codepipeline.model.CreatePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
