package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{AWSRegionName, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListActionTypesRequest(
    actionOwnerFilter: Optional[zio.aws.codepipeline.model.ActionOwner] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    regionFilter: Optional[AWSRegionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest = {
    import ListActionTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
      .builder()
      .optionallyWith(actionOwnerFilter.map(value => value.unwrap))(
        _.actionOwnerFilter
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        regionFilter.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.regionFilter)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListActionTypesRequest.ReadOnly =
    zio.aws.codepipeline.model.ListActionTypesRequest.wrap(buildAwsValue())
}
object ListActionTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListActionTypesRequest =
      zio.aws.codepipeline.model.ListActionTypesRequest(
        actionOwnerFilter.map(value => value),
        nextToken.map(value => value),
        regionFilter.map(value => value)
      )
    def actionOwnerFilter: Optional[zio.aws.codepipeline.model.ActionOwner]
    def nextToken: Optional[NextToken]
    def regionFilter: Optional[AWSRegionName]
    def getActionOwnerFilter
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionOwner] =
      AwsError.unwrapOptionField("actionOwnerFilter", actionOwnerFilter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegionFilter: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("regionFilter", regionFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
  ) extends zio.aws.codepipeline.model.ListActionTypesRequest.ReadOnly {
    override val actionOwnerFilter
        : Optional[zio.aws.codepipeline.model.ActionOwner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionOwnerFilter())
        .map(value => zio.aws.codepipeline.model.ActionOwner.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
    override val regionFilter: Optional[AWSRegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.regionFilter())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
  ): zio.aws.codepipeline.model.ListActionTypesRequest.ReadOnly = new Wrapper(
    impl
  )
}
