package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait TriggerType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.TriggerType
}
object TriggerType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.TriggerType
  ): zio.aws.codepipeline.model.TriggerType = value match {
    case software.amazon.awssdk.services.codepipeline.model.TriggerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.TriggerType.CREATE_PIPELINE =>
      val r = CreatePipeline
      r
    case software.amazon.awssdk.services.codepipeline.model.TriggerType.START_PIPELINE_EXECUTION =>
      val r = StartPipelineExecution
      r
    case software.amazon.awssdk.services.codepipeline.model.TriggerType.POLL_FOR_SOURCE_CHANGES =>
      val r = PollForSourceChanges
      r
    case software.amazon.awssdk.services.codepipeline.model.TriggerType.WEBHOOK =>
      val r = Webhook
      r
    case software.amazon.awssdk.services.codepipeline.model.TriggerType.CLOUD_WATCH_EVENT =>
      val r = CloudWatchEvent
      r
    case software.amazon.awssdk.services.codepipeline.model.TriggerType.PUT_ACTION_REVISION =>
      val r = PutActionRevision
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.TriggerType =
      software.amazon.awssdk.services.codepipeline.model.TriggerType.UNKNOWN_TO_SDK_VERSION
  }
  case object CreatePipeline extends zio.aws.codepipeline.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.TriggerType =
      software.amazon.awssdk.services.codepipeline.model.TriggerType.CREATE_PIPELINE
  }
  case object StartPipelineExecution
      extends zio.aws.codepipeline.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.TriggerType =
      software.amazon.awssdk.services.codepipeline.model.TriggerType.START_PIPELINE_EXECUTION
  }
  case object PollForSourceChanges
      extends zio.aws.codepipeline.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.TriggerType =
      software.amazon.awssdk.services.codepipeline.model.TriggerType.POLL_FOR_SOURCE_CHANGES
  }
  case object Webhook extends zio.aws.codepipeline.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.TriggerType =
      software.amazon.awssdk.services.codepipeline.model.TriggerType.WEBHOOK
  }
  case object CloudWatchEvent extends zio.aws.codepipeline.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.TriggerType =
      software.amazon.awssdk.services.codepipeline.model.TriggerType.CLOUD_WATCH_EVENT
  }
  case object PutActionRevision extends zio.aws.codepipeline.model.TriggerType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.TriggerType =
      software.amazon.awssdk.services.codepipeline.model.TriggerType.PUT_ACTION_REVISION
  }
}
