package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ClientToken,
  Nonce,
  ThirdPartyJobId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AcknowledgeThirdPartyJobRequest(
    jobId: ThirdPartyJobId,
    nonce: Nonce,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest = {
    import AcknowledgeThirdPartyJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest
      .builder()
      .jobId(ThirdPartyJobId.unwrap(jobId): java.lang.String)
      .nonce(Nonce.unwrap(nonce): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest.ReadOnly =
    zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest
      .wrap(buildAwsValue())
}
object AcknowledgeThirdPartyJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest =
      zio.aws.codepipeline.model
        .AcknowledgeThirdPartyJobRequest(jobId, nonce, clientToken)
    def jobId: ThirdPartyJobId
    def nonce: Nonce
    def clientToken: ClientToken
    def getJobId: ZIO[Any, Nothing, ThirdPartyJobId] = ZIO.succeed(jobId)
    def getNonce: ZIO[Any, Nothing, Nonce] = ZIO.succeed(nonce)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest
  ) extends zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest.ReadOnly {
    override val jobId: ThirdPartyJobId =
      zio.aws.codepipeline.model.primitives.ThirdPartyJobId(impl.jobId())
    override val nonce: Nonce =
      zio.aws.codepipeline.model.primitives.Nonce(impl.nonce())
    override val clientToken: ClientToken =
      zio.aws.codepipeline.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeThirdPartyJobRequest
  ): zio.aws.codepipeline.model.AcknowledgeThirdPartyJobRequest.ReadOnly =
    new Wrapper(impl)
}
