package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.LambdaFunctionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LambdaExecutorConfiguration(
    lambdaFunctionArn: LambdaFunctionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.LambdaExecutorConfiguration = {
    import LambdaExecutorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.LambdaExecutorConfiguration
      .builder()
      .lambdaFunctionArn(
        LambdaFunctionArn.unwrap(lambdaFunctionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly =
    zio.aws.codepipeline.model.LambdaExecutorConfiguration.wrap(buildAwsValue())
}
object LambdaExecutorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.LambdaExecutorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.LambdaExecutorConfiguration =
      zio.aws.codepipeline.model.LambdaExecutorConfiguration(lambdaFunctionArn)
    def lambdaFunctionArn: LambdaFunctionArn
    def getLambdaFunctionArn: ZIO[Any, Nothing, LambdaFunctionArn] =
      ZIO.succeed(lambdaFunctionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.LambdaExecutorConfiguration
  ) extends zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly {
    override val lambdaFunctionArn: LambdaFunctionArn =
      zio.aws.codepipeline.model.primitives
        .LambdaFunctionArn(impl.lambdaFunctionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.LambdaExecutorConfiguration
  ): zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly =
    new Wrapper(impl)
}
