package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RetryStageExecutionResponse(
    pipelineExecutionId: Optional[PipelineExecutionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse = {
    import RetryStageExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly =
    zio.aws.codepipeline.model.RetryStageExecutionResponse.wrap(buildAwsValue())
}
object RetryStageExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RetryStageExecutionResponse =
      zio.aws.codepipeline.model
        .RetryStageExecutionResponse(pipelineExecutionId.map(value => value))
    def pipelineExecutionId: Optional[PipelineExecutionId]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse
  ) extends zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly {
    override val pipelineExecutionId: Optional[PipelineExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionResponse
  ): zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
