package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StageExecution(
    pipelineExecutionId: PipelineExecutionId,
    status: zio.aws.codepipeline.model.StageExecutionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageExecution = {
    import StageExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageExecution
      .builder()
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageExecution.ReadOnly =
    zio.aws.codepipeline.model.StageExecution.wrap(buildAwsValue())
}
object StageExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageExecution =
      zio.aws.codepipeline.model.StageExecution(pipelineExecutionId, status)
    def pipelineExecutionId: PipelineExecutionId
    def status: zio.aws.codepipeline.model.StageExecutionStatus
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.StageExecutionStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageExecution
  ) extends zio.aws.codepipeline.model.StageExecution.ReadOnly {
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
    override val status: zio.aws.codepipeline.model.StageExecutionStatus =
      zio.aws.codepipeline.model.StageExecutionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageExecution
  ): zio.aws.codepipeline.model.StageExecution.ReadOnly = new Wrapper(impl)
}
