package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  Timestamp,
  PipelineVersion,
  PipelineName
}
import scala.jdk.CollectionConverters.*
final case class GetPipelineStateResponse(
    pipelineName: Optional[PipelineName] = Optional.Absent,
    pipelineVersion: Optional[PipelineVersion] = Optional.Absent,
    stageStates: Optional[Iterable[zio.aws.codepipeline.model.StageState]] =
      Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    updated: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse = {
    import GetPipelineStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
      .builder()
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineVersion.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.pipelineVersion)
      .optionallyWith(
        stageStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stageStates)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(updated.map(value => Timestamp.unwrap(value): Instant))(
        _.updated
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineStateResponse.wrap(buildAwsValue())
}
object GetPipelineStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineStateResponse =
      zio.aws.codepipeline.model.GetPipelineStateResponse(
        pipelineName.map(value => value),
        pipelineVersion.map(value => value),
        stageStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        created.map(value => value),
        updated.map(value => value)
      )
    def pipelineName: Optional[PipelineName]
    def pipelineVersion: Optional[PipelineVersion]
    def stageStates
        : Optional[List[zio.aws.codepipeline.model.StageState.ReadOnly]]
    def created: Optional[Timestamp]
    def updated: Optional[Timestamp]
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("pipelineVersion", pipelineVersion)
    def getStageStates: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.StageState.ReadOnly
    ]] = AwsError.unwrapOptionField("stageStates", stageStates)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updated", updated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
  ) extends zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly {
    override val pipelineName: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineName(value))
    override val pipelineVersion: Optional[PipelineVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineVersion())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineVersion(value)
        )
    override val stageStates
        : Optional[List[zio.aws.codepipeline.model.StageState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.StageState.wrap(item)
          }.toList
        )
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val updated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updated())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineStateResponse
  ): zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly = new Wrapper(
    impl
  )
}
