package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutWebhookResponse(
    webhook: Optional[zio.aws.codepipeline.model.ListWebhookItem] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse = {
    import PutWebhookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse
      .builder()
      .optionallyWith(webhook.map(value => value.buildAwsValue()))(_.webhook)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly =
    zio.aws.codepipeline.model.PutWebhookResponse.wrap(buildAwsValue())
}
object PutWebhookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutWebhookResponse =
      zio.aws.codepipeline.model
        .PutWebhookResponse(webhook.map(value => value.asEditable))
    def webhook: Optional[zio.aws.codepipeline.model.ListWebhookItem.ReadOnly]
    def getWebhook: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ListWebhookItem.ReadOnly
    ] = AwsError.unwrapOptionField("webhook", webhook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse
  ) extends zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly {
    override val webhook
        : Optional[zio.aws.codepipeline.model.ListWebhookItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webhook())
        .map(value => zio.aws.codepipeline.model.ListWebhookItem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutWebhookResponse
  ): zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly = new Wrapper(impl)
}
