package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResolvedPipelineVariable(
    name: Optional[String] = Optional.Absent,
    resolvedValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ResolvedPipelineVariable = {
    import ResolvedPipelineVariable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ResolvedPipelineVariable
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(resolvedValue.map(value => value: java.lang.String))(
        _.resolvedValue
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ResolvedPipelineVariable.ReadOnly =
    zio.aws.codepipeline.model.ResolvedPipelineVariable.wrap(buildAwsValue())
}
object ResolvedPipelineVariable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ResolvedPipelineVariable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ResolvedPipelineVariable =
      zio.aws.codepipeline.model.ResolvedPipelineVariable(
        name.map(value => value),
        resolvedValue.map(value => value)
      )
    def name: Optional[String]
    def resolvedValue: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getResolvedValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resolvedValue", resolvedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ResolvedPipelineVariable
  ) extends zio.aws.codepipeline.model.ResolvedPipelineVariable.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val resolvedValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ResolvedPipelineVariable
  ): zio.aws.codepipeline.model.ResolvedPipelineVariable.ReadOnly = new Wrapper(
    impl
  )
}
