package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BeforeEntryConditions(
    conditions: Iterable[zio.aws.codepipeline.model.Condition]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.BeforeEntryConditions = {
    import BeforeEntryConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.BeforeEntryConditions
      .builder()
      .conditions(conditions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.BeforeEntryConditions.ReadOnly =
    zio.aws.codepipeline.model.BeforeEntryConditions.wrap(buildAwsValue())
}
object BeforeEntryConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.BeforeEntryConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.BeforeEntryConditions =
      zio.aws.codepipeline.model.BeforeEntryConditions(conditions.map { item =>
        item.asEditable
      })
    def conditions: List[zio.aws.codepipeline.model.Condition.ReadOnly]
    def getConditions: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.Condition.ReadOnly
    ]] = ZIO.succeed(conditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.BeforeEntryConditions
  ) extends zio.aws.codepipeline.model.BeforeEntryConditions.ReadOnly {
    override val conditions
        : List[zio.aws.codepipeline.model.Condition.ReadOnly] = impl
      .conditions()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.Condition.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.BeforeEntryConditions
  ): zio.aws.codepipeline.model.BeforeEntryConditions.ReadOnly = new Wrapper(
    impl
  )
}
