package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Condition(
    result: Optional[zio.aws.codepipeline.model.Result] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.codepipeline.model.RuleDeclaration]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.Condition
      .builder()
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.Condition.ReadOnly =
    zio.aws.codepipeline.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.Condition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.Condition =
      zio.aws.codepipeline.model.Condition(
        result.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def result: Optional[zio.aws.codepipeline.model.Result]
    def rules
        : Optional[List[zio.aws.codepipeline.model.RuleDeclaration.ReadOnly]]
    def getResult: ZIO[Any, AwsError, zio.aws.codepipeline.model.Result] =
      AwsError.unwrapOptionField("result", result)
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.RuleDeclaration.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.Condition
  ) extends zio.aws.codepipeline.model.Condition.ReadOnly {
    override val result: Optional[zio.aws.codepipeline.model.Result] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.codepipeline.model.Result.wrap(value))
    override val rules
        : Optional[List[zio.aws.codepipeline.model.RuleDeclaration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.RuleDeclaration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.Condition
  ): zio.aws.codepipeline.model.Condition.ReadOnly = new Wrapper(impl)
}
