package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionType {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ExecutionType
}
object ExecutionType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ExecutionType
  ): zio.aws.codepipeline.model.ExecutionType = value match {
    case software.amazon.awssdk.services.codepipeline.model.ExecutionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ExecutionType.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.codepipeline.model.ExecutionType.ROLLBACK =>
      val r = ROLLBACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutionType =
      software.amazon.awssdk.services.codepipeline.model.ExecutionType.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.codepipeline.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutionType =
      software.amazon.awssdk.services.codepipeline.model.ExecutionType.STANDARD
  }
  case object ROLLBACK extends zio.aws.codepipeline.model.ExecutionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutionType =
      software.amazon.awssdk.services.codepipeline.model.ExecutionType.ROLLBACK
  }
}
