package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailureConditions(
    result: Optional[zio.aws.codepipeline.model.Result] = Optional.Absent,
    retryConfiguration: Optional[
      zio.aws.codepipeline.model.RetryConfiguration
    ] = Optional.Absent,
    conditions: Optional[Iterable[zio.aws.codepipeline.model.Condition]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.FailureConditions = {
    import FailureConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.FailureConditions
      .builder()
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(retryConfiguration.map(value => value.buildAwsValue()))(
        _.retryConfiguration
      )
      .optionallyWith(
        conditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conditions)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.FailureConditions.ReadOnly =
    zio.aws.codepipeline.model.FailureConditions.wrap(buildAwsValue())
}
object FailureConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.FailureConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.FailureConditions =
      zio.aws.codepipeline.model.FailureConditions(
        result.map(value => value),
        retryConfiguration.map(value => value.asEditable),
        conditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def result: Optional[zio.aws.codepipeline.model.Result]
    def retryConfiguration
        : Optional[zio.aws.codepipeline.model.RetryConfiguration.ReadOnly]
    def conditions
        : Optional[List[zio.aws.codepipeline.model.Condition.ReadOnly]]
    def getResult: ZIO[Any, AwsError, zio.aws.codepipeline.model.Result] =
      AwsError.unwrapOptionField("result", result)
    def getRetryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.RetryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("retryConfiguration", retryConfiguration)
    def getConditions: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.Condition.ReadOnly
    ]] = AwsError.unwrapOptionField("conditions", conditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.FailureConditions
  ) extends zio.aws.codepipeline.model.FailureConditions.ReadOnly {
    override val result: Optional[zio.aws.codepipeline.model.Result] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.codepipeline.model.Result.wrap(value))
    override val retryConfiguration
        : Optional[zio.aws.codepipeline.model.RetryConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryConfiguration())
        .map(value => zio.aws.codepipeline.model.RetryConfiguration.wrap(value))
    override val conditions
        : Optional[List[zio.aws.codepipeline.model.Condition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Condition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.FailureConditions
  ): zio.aws.codepipeline.model.FailureConditions.ReadOnly = new Wrapper(impl)
}
