package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class LatestInPipelineExecutionFilter(
    pipelineExecutionId: PipelineExecutionId,
    startTimeRange: zio.aws.codepipeline.model.StartTimeRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.LatestInPipelineExecutionFilter = {
    import LatestInPipelineExecutionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.LatestInPipelineExecutionFilter
      .builder()
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .startTimeRange(startTimeRange.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.LatestInPipelineExecutionFilter.ReadOnly =
    zio.aws.codepipeline.model.LatestInPipelineExecutionFilter
      .wrap(buildAwsValue())
}
object LatestInPipelineExecutionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.LatestInPipelineExecutionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.LatestInPipelineExecutionFilter =
      zio.aws.codepipeline.model
        .LatestInPipelineExecutionFilter(pipelineExecutionId, startTimeRange)
    def pipelineExecutionId: PipelineExecutionId
    def startTimeRange: zio.aws.codepipeline.model.StartTimeRange
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
    def getStartTimeRange
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.StartTimeRange] =
      ZIO.succeed(startTimeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.LatestInPipelineExecutionFilter
  ) extends zio.aws.codepipeline.model.LatestInPipelineExecutionFilter.ReadOnly {
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
    override val startTimeRange: zio.aws.codepipeline.model.StartTimeRange =
      zio.aws.codepipeline.model.StartTimeRange.wrap(impl.startTimeRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.LatestInPipelineExecutionFilter
  ): zio.aws.codepipeline.model.LatestInPipelineExecutionFilter.ReadOnly =
    new Wrapper(impl)
}
