package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.AWSRegionName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRuleTypesRequest(
    ruleOwnerFilter: Optional[zio.aws.codepipeline.model.RuleOwner] =
      Optional.Absent,
    regionFilter: Optional[AWSRegionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListRuleTypesRequest = {
    import ListRuleTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListRuleTypesRequest
      .builder()
      .optionallyWith(ruleOwnerFilter.map(value => value.unwrap))(
        _.ruleOwnerFilter
      )
      .optionallyWith(
        regionFilter.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.regionFilter)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListRuleTypesRequest.ReadOnly =
    zio.aws.codepipeline.model.ListRuleTypesRequest.wrap(buildAwsValue())
}
object ListRuleTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListRuleTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListRuleTypesRequest =
      zio.aws.codepipeline.model.ListRuleTypesRequest(
        ruleOwnerFilter.map(value => value),
        regionFilter.map(value => value)
      )
    def ruleOwnerFilter: Optional[zio.aws.codepipeline.model.RuleOwner]
    def regionFilter: Optional[AWSRegionName]
    def getRuleOwnerFilter
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.RuleOwner] =
      AwsError.unwrapOptionField("ruleOwnerFilter", ruleOwnerFilter)
    def getRegionFilter: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("regionFilter", regionFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleTypesRequest
  ) extends zio.aws.codepipeline.model.ListRuleTypesRequest.ReadOnly {
    override val ruleOwnerFilter
        : Optional[zio.aws.codepipeline.model.RuleOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleOwnerFilter())
      .map(value => zio.aws.codepipeline.model.RuleOwner.wrap(value))
    override val regionFilter: Optional[AWSRegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.regionFilter())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListRuleTypesRequest
  ): zio.aws.codepipeline.model.ListRuleTypesRequest.ReadOnly = new Wrapper(
    impl
  )
}
