package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{FilePath, ArtifactName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OutputArtifact(
    name: ArtifactName,
    files: Optional[Iterable[FilePath]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.OutputArtifact = {
    import OutputArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.OutputArtifact
      .builder()
      .name(ArtifactName.unwrap(name): java.lang.String)
      .optionallyWith(
        files.map(value =>
          value.map { item =>
            FilePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.files)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.OutputArtifact.ReadOnly =
    zio.aws.codepipeline.model.OutputArtifact.wrap(buildAwsValue())
}
object OutputArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.OutputArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.OutputArtifact =
      zio.aws.codepipeline.model.OutputArtifact(name, files.map(value => value))
    def name: ArtifactName
    def files: Optional[List[FilePath]]
    def getName: ZIO[Any, Nothing, ArtifactName] = ZIO.succeed(name)
    def getFiles: ZIO[Any, AwsError, List[FilePath]] =
      AwsError.unwrapOptionField("files", files)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.OutputArtifact
  ) extends zio.aws.codepipeline.model.OutputArtifact.ReadOnly {
    override val name: ArtifactName =
      zio.aws.codepipeline.model.primitives.ArtifactName(impl.name())
    override val files: Optional[List[FilePath]] = zio.aws.core.internal
      .optionalFromNullable(impl.files())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.primitives.FilePath(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.OutputArtifact
  ): zio.aws.codepipeline.model.OutputArtifact.ReadOnly = new Wrapper(impl)
}
