package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PipelineExecutionId,
  StageName,
  PipelineName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OverrideStageConditionRequest(
    pipelineName: PipelineName,
    stageName: StageName,
    pipelineExecutionId: PipelineExecutionId,
    conditionType: zio.aws.codepipeline.model.ConditionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionRequest = {
    import OverrideStageConditionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .stageName(StageName.unwrap(stageName): java.lang.String)
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .conditionType(conditionType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.OverrideStageConditionRequest.ReadOnly =
    zio.aws.codepipeline.model.OverrideStageConditionRequest
      .wrap(buildAwsValue())
}
object OverrideStageConditionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.OverrideStageConditionRequest =
      zio.aws.codepipeline.model.OverrideStageConditionRequest(
        pipelineName,
        stageName,
        pipelineExecutionId,
        conditionType
      )
    def pipelineName: PipelineName
    def stageName: StageName
    def pipelineExecutionId: PipelineExecutionId
    def conditionType: zio.aws.codepipeline.model.ConditionType
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStageName: ZIO[Any, Nothing, StageName] = ZIO.succeed(stageName)
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
    def getConditionType
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ConditionType] =
      ZIO.succeed(conditionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionRequest
  ) extends zio.aws.codepipeline.model.OverrideStageConditionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val stageName: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.stageName())
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
    override val conditionType: zio.aws.codepipeline.model.ConditionType =
      zio.aws.codepipeline.model.ConditionType.wrap(impl.conditionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.OverrideStageConditionRequest
  ): zio.aws.codepipeline.model.OverrideStageConditionRequest.ReadOnly =
    new Wrapper(impl)
}
