package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ApprovalToken,
  ActionName,
  StageName,
  PipelineName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutApprovalResultRequest(
    pipelineName: PipelineName,
    stageName: StageName,
    actionName: ActionName,
    result: zio.aws.codepipeline.model.ApprovalResult,
    token: ApprovalToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest = {
    import PutApprovalResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .stageName(StageName.unwrap(stageName): java.lang.String)
      .actionName(ActionName.unwrap(actionName): java.lang.String)
      .result(result.buildAwsValue())
      .token(ApprovalToken.unwrap(token): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PutApprovalResultRequest.ReadOnly =
    zio.aws.codepipeline.model.PutApprovalResultRequest.wrap(buildAwsValue())
}
object PutApprovalResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutApprovalResultRequest =
      zio.aws.codepipeline.model.PutApprovalResultRequest(
        pipelineName,
        stageName,
        actionName,
        result.asEditable,
        token
      )
    def pipelineName: PipelineName
    def stageName: StageName
    def actionName: ActionName
    def result: zio.aws.codepipeline.model.ApprovalResult.ReadOnly
    def token: ApprovalToken
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStageName: ZIO[Any, Nothing, StageName] = ZIO.succeed(stageName)
    def getActionName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(actionName)
    def getResult: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ApprovalResult.ReadOnly
    ] = ZIO.succeed(result)
    def getToken: ZIO[Any, Nothing, ApprovalToken] = ZIO.succeed(token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest
  ) extends zio.aws.codepipeline.model.PutApprovalResultRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val stageName: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.stageName())
    override val actionName: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.actionName())
    override val result: zio.aws.codepipeline.model.ApprovalResult.ReadOnly =
      zio.aws.codepipeline.model.ApprovalResult.wrap(impl.result())
    override val token: ApprovalToken =
      zio.aws.codepipeline.model.primitives.ApprovalToken(impl.token())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutApprovalResultRequest
  ): zio.aws.codepipeline.model.PutApprovalResultRequest.ReadOnly = new Wrapper(
    impl
  )
}
