package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleExecutionFilter(
    pipelineExecutionId: Optional[PipelineExecutionId] = Optional.Absent,
    latestInPipelineExecution: Optional[
      zio.aws.codepipeline.model.LatestInPipelineExecutionFilter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RuleExecutionFilter = {
    import RuleExecutionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionFilter
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .optionallyWith(
        latestInPipelineExecution.map(value => value.buildAwsValue())
      )(_.latestInPipelineExecution)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.RuleExecutionFilter.ReadOnly =
    zio.aws.codepipeline.model.RuleExecutionFilter.wrap(buildAwsValue())
}
object RuleExecutionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RuleExecutionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RuleExecutionFilter =
      zio.aws.codepipeline.model.RuleExecutionFilter(
        pipelineExecutionId.map(value => value),
        latestInPipelineExecution.map(value => value.asEditable)
      )
    def pipelineExecutionId: Optional[PipelineExecutionId]
    def latestInPipelineExecution: Optional[
      zio.aws.codepipeline.model.LatestInPipelineExecutionFilter.ReadOnly
    ]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
    def getLatestInPipelineExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.LatestInPipelineExecutionFilter.ReadOnly
    ] = AwsError.unwrapOptionField(
      "latestInPipelineExecution",
      latestInPipelineExecution
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionFilter
  ) extends zio.aws.codepipeline.model.RuleExecutionFilter.ReadOnly {
    override val pipelineExecutionId: Optional[PipelineExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
        )
    override val latestInPipelineExecution: Optional[
      zio.aws.codepipeline.model.LatestInPipelineExecutionFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.latestInPipelineExecution())
      .map(value =>
        zio.aws.codepipeline.model.LatestInPipelineExecutionFilter.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RuleExecutionFilter
  ): zio.aws.codepipeline.model.RuleExecutionFilter.ReadOnly = new Wrapper(impl)
}
