package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait RuleOwner {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.RuleOwner
}
object RuleOwner {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.RuleOwner
  ): zio.aws.codepipeline.model.RuleOwner = value match {
    case software.amazon.awssdk.services.codepipeline.model.RuleOwner.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.RuleOwner.AWS =>
      val r = AWS
      r
  }
  case object unknownToSdkVersion extends zio.aws.codepipeline.model.RuleOwner {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleOwner =
      software.amazon.awssdk.services.codepipeline.model.RuleOwner.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS extends zio.aws.codepipeline.model.RuleOwner {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.RuleOwner =
      software.amazon.awssdk.services.codepipeline.model.RuleOwner.AWS
  }
}
