package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait SourceRevisionType {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.SourceRevisionType
}
object SourceRevisionType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.SourceRevisionType
  ): zio.aws.codepipeline.model.SourceRevisionType = value match {
    case software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.COMMIT_ID =>
      val r = COMMIT_ID
      r
    case software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.IMAGE_DIGEST =>
      val r = IMAGE_DIGEST
      r
    case software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.S3_OBJECT_VERSION_ID =>
      val r = S3_OBJECT_VERSION_ID
      r
    case software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.S3_OBJECT_KEY =>
      val r = S3_OBJECT_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.SourceRevisionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.SourceRevisionType =
      software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.UNKNOWN_TO_SDK_VERSION
  }
  case object COMMIT_ID extends zio.aws.codepipeline.model.SourceRevisionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.SourceRevisionType =
      software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.COMMIT_ID
  }
  case object IMAGE_DIGEST
      extends zio.aws.codepipeline.model.SourceRevisionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.SourceRevisionType =
      software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.IMAGE_DIGEST
  }
  case object S3_OBJECT_VERSION_ID
      extends zio.aws.codepipeline.model.SourceRevisionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.SourceRevisionType =
      software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.S3_OBJECT_VERSION_ID
  }
  case object S3_OBJECT_KEY
      extends zio.aws.codepipeline.model.SourceRevisionType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.SourceRevisionType =
      software.amazon.awssdk.services.codepipeline.model.SourceRevisionType.S3_OBJECT_KEY
  }
}
