package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ExecutionSummary
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StageConditionsExecution(
    status: Optional[zio.aws.codepipeline.model.ConditionExecutionStatus] =
      Optional.Absent,
    summary: Optional[ExecutionSummary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageConditionsExecution = {
    import StageConditionsExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageConditionsExecution
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        summary.map(value => ExecutionSummary.unwrap(value): java.lang.String)
      )(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageConditionsExecution.ReadOnly =
    zio.aws.codepipeline.model.StageConditionsExecution.wrap(buildAwsValue())
}
object StageConditionsExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageConditionsExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageConditionsExecution =
      zio.aws.codepipeline.model.StageConditionsExecution(
        status.map(value => value),
        summary.map(value => value)
      )
    def status: Optional[zio.aws.codepipeline.model.ConditionExecutionStatus]
    def summary: Optional[ExecutionSummary]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ConditionExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getSummary: ZIO[Any, AwsError, ExecutionSummary] =
      AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageConditionsExecution
  ) extends zio.aws.codepipeline.model.StageConditionsExecution.ReadOnly {
    override val status
        : Optional[zio.aws.codepipeline.model.ConditionExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codepipeline.model.ConditionExecutionStatus.wrap(value)
        )
    override val summary: Optional[ExecutionSummary] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ExecutionSummary(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageConditionsExecution
  ): zio.aws.codepipeline.model.StageConditionsExecution.ReadOnly = new Wrapper(
    impl
  )
}
