package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait StageExecutionStatus {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus
}
object StageExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus
  ): zio.aws.codepipeline.model.StageExecutionStatus = value match {
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.SKIPPED =>
      val r = Skipped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Cancelled
      extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.CANCELLED
  }
  case object InProgress
      extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.FAILED
  }
  case object Stopped extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.STOPPED
  }
  case object Stopping extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.STOPPING
  }
  case object Succeeded
      extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.SUCCEEDED
  }
  case object Skipped extends zio.aws.codepipeline.model.StageExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.StageExecutionStatus.SKIPPED
  }
}
