package zio.aws.codepipeline
import zio.aws.codepipeline.model.GetPipelineExecutionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient
import zio.stream.ZStream
import zio.aws.codepipeline.model.{
  PollForJobsRequest,
  PollForThirdPartyJobsRequest,
  ListRuleExecutionsRequest,
  PutJobFailureResultRequest,
  DeleteCustomActionTypeRequest,
  GetPipelineExecutionRequest,
  PutJobSuccessResultRequest,
  ListPipelineExecutionsRequest,
  EnableStageTransitionRequest,
  DisableStageTransitionRequest,
  StopPipelineExecutionRequest,
  OverrideStageConditionRequest,
  ListActionExecutionsRequest,
  RetryStageExecutionRequest,
  UpdateActionTypeRequest,
  ListTagsForResourceRequest,
  GetJobDetailsRequest,
  ListActionTypesRequest,
  ListPipelinesRequest,
  GetPipelineStateRequest,
  DeregisterWebhookWithThirdPartyRequest,
  GetThirdPartyJobDetailsRequest,
  PutWebhookRequest,
  PutActionRevisionRequest,
  DeletePipelineRequest,
  AcknowledgeJobRequest,
  RegisterWebhookWithThirdPartyRequest,
  GetActionTypeRequest,
  DeleteWebhookRequest,
  CreateCustomActionTypeRequest,
  UntagResourceRequest,
  ListWebhooksRequest,
  GetPipelineRequest,
  CreatePipelineRequest,
  ListRuleTypesRequest,
  PutThirdPartyJobSuccessResultRequest,
  UpdatePipelineRequest,
  PutApprovalResultRequest,
  RollbackStageRequest,
  TagResourceRequest,
  StartPipelineExecutionRequest,
  AcknowledgeThirdPartyJobRequest,
  PutThirdPartyJobFailureResultRequest
}
object CodePipelineMock extends Mock[CodePipeline] {
  object RetryStageExecution
      extends Effect[
        RetryStageExecutionRequest,
        AwsError,
        zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly
      ]
  object GetPipeline
      extends Effect[
        GetPipelineRequest,
        AwsError,
        zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly
      ]
  object ListPipelineExecutions
      extends Stream[
        ListPipelineExecutionsRequest,
        AwsError,
        zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly
      ]
  object ListPipelineExecutionsPaginated
      extends Effect[
        ListPipelineExecutionsRequest,
        AwsError,
        zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly
      ]
  object ListWebhooks
      extends Stream[
        ListWebhooksRequest,
        AwsError,
        zio.aws.codepipeline.model.ListWebhookItem.ReadOnly
      ]
  object ListWebhooksPaginated
      extends Effect[
        ListWebhooksRequest,
        AwsError,
        zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly
      ]
  object ListActionExecutions
      extends Stream[
        ListActionExecutionsRequest,
        AwsError,
        zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly
      ]
  object ListActionExecutionsPaginated
      extends Effect[
        ListActionExecutionsRequest,
        AwsError,
        zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly
      ]
  object UpdatePipeline
      extends Effect[
        UpdatePipelineRequest,
        AwsError,
        zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly
      ]
  object StartPipelineExecution
      extends Effect[
        StartPipelineExecutionRequest,
        AwsError,
        zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly
      ]
  object PutJobSuccessResult
      extends Effect[PutJobSuccessResultRequest, AwsError, Unit]
  object DeleteWebhook
      extends Effect[
        DeleteWebhookRequest,
        AwsError,
        zio.aws.codepipeline.model.DeleteWebhookResponse.ReadOnly
      ]
  object ListActionTypes
      extends Stream[
        ListActionTypesRequest,
        AwsError,
        zio.aws.codepipeline.model.ActionType.ReadOnly
      ]
  object ListActionTypesPaginated
      extends Effect[
        ListActionTypesRequest,
        AwsError,
        zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly
      ]
  object AcknowledgeThirdPartyJob
      extends Effect[
        AcknowledgeThirdPartyJobRequest,
        AwsError,
        zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly
      ]
  object PutJobFailureResult
      extends Effect[PutJobFailureResultRequest, AwsError, Unit]
  object ListPipelines
      extends Stream[
        ListPipelinesRequest,
        AwsError,
        zio.aws.codepipeline.model.PipelineSummary.ReadOnly
      ]
  object ListPipelinesPaginated
      extends Effect[
        ListPipelinesRequest,
        AwsError,
        zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly
      ]
  object AcknowledgeJob
      extends Effect[
        AcknowledgeJobRequest,
        AwsError,
        zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly
      ]
  object ListRuleTypes
      extends Effect[
        ListRuleTypesRequest,
        AwsError,
        zio.aws.codepipeline.model.ListRuleTypesResponse.ReadOnly
      ]
  object UpdateActionType
      extends Effect[UpdateActionTypeRequest, AwsError, Unit]
  object PutApprovalResult
      extends Effect[
        PutApprovalResultRequest,
        AwsError,
        zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly
      ]
  object GetPipelineState
      extends Effect[
        GetPipelineStateRequest,
        AwsError,
        zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly
      ]
  object PollForJobs
      extends Effect[
        PollForJobsRequest,
        AwsError,
        zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codepipeline.model.UntagResourceResponse.ReadOnly
      ]
  object CreateCustomActionType
      extends Effect[
        CreateCustomActionTypeRequest,
        AwsError,
        zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly
      ]
  object PollForThirdPartyJobs
      extends Effect[
        PollForThirdPartyJobsRequest,
        AwsError,
        zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly
      ]
  object PutThirdPartyJobFailureResult
      extends Effect[PutThirdPartyJobFailureResultRequest, AwsError, Unit]
  object PutWebhook
      extends Effect[
        PutWebhookRequest,
        AwsError,
        zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly
      ]
  object DeletePipeline extends Effect[DeletePipelineRequest, AwsError, Unit]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codepipeline.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codepipeline.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codepipeline.model.TagResourceResponse.ReadOnly
      ]
  object DisableStageTransition
      extends Effect[DisableStageTransitionRequest, AwsError, Unit]
  object DeleteCustomActionType
      extends Effect[DeleteCustomActionTypeRequest, AwsError, Unit]
  object PutThirdPartyJobSuccessResult
      extends Effect[PutThirdPartyJobSuccessResultRequest, AwsError, Unit]
  object GetActionType
      extends Effect[
        GetActionTypeRequest,
        AwsError,
        zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly
      ]
  object StopPipelineExecution
      extends Effect[
        StopPipelineExecutionRequest,
        AwsError,
        zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly
      ]
  object RollbackStage
      extends Effect[
        RollbackStageRequest,
        AwsError,
        zio.aws.codepipeline.model.RollbackStageResponse.ReadOnly
      ]
  object DeregisterWebhookWithThirdParty
      extends Effect[
        DeregisterWebhookWithThirdPartyRequest,
        AwsError,
        zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyResponse.ReadOnly
      ]
  object RegisterWebhookWithThirdParty
      extends Effect[
        RegisterWebhookWithThirdPartyRequest,
        AwsError,
        zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyResponse.ReadOnly
      ]
  object CreatePipeline
      extends Effect[
        CreatePipelineRequest,
        AwsError,
        zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly
      ]
  object EnableStageTransition
      extends Effect[EnableStageTransitionRequest, AwsError, Unit]
  object GetJobDetails
      extends Effect[
        GetJobDetailsRequest,
        AwsError,
        zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly
      ]
  object GetThirdPartyJobDetails
      extends Effect[
        GetThirdPartyJobDetailsRequest,
        AwsError,
        zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly
      ]
  object PutActionRevision
      extends Effect[
        PutActionRevisionRequest,
        AwsError,
        zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly
      ]
  object GetPipelineExecution
      extends Effect[GetPipelineExecutionRequest, AwsError, ReadOnly]
  object ListRuleExecutions
      extends Stream[
        ListRuleExecutionsRequest,
        AwsError,
        zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly
      ]
  object ListRuleExecutionsPaginated
      extends Effect[
        ListRuleExecutionsRequest,
        AwsError,
        zio.aws.codepipeline.model.ListRuleExecutionsResponse.ReadOnly
      ]
  object OverrideStageCondition
      extends Effect[OverrideStageConditionRequest, AwsError, Unit]
  val compose: URLayer[Proxy, CodePipeline] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodePipeline] { rts =>
        zio.ZIO.succeed {
          new CodePipeline {
            val api: CodePipelineAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodePipeline = this
            def retryStageExecution(request: RetryStageExecutionRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.RetryStageExecutionResponse.ReadOnly
            ] = proxy(RetryStageExecution, request)
            def getPipeline(request: GetPipelineRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.GetPipelineResponse.ReadOnly
            ] = proxy(GetPipeline, request)
            def listPipelineExecutions(
                request: ListPipelineExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPipelineExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPipelineExecutionsPaginated(
                request: ListPipelineExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.ListPipelineExecutionsResponse.ReadOnly
            ] = proxy(ListPipelineExecutionsPaginated, request)
            def listWebhooks(request: ListWebhooksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codepipeline.model.ListWebhookItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWebhooks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWebhooksPaginated(request: ListWebhooksRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.ListWebhooksResponse.ReadOnly
            ] = proxy(ListWebhooksPaginated, request)
            def listActionExecutions(
                request: ListActionExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codepipeline.model.ActionExecutionDetail.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListActionExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listActionExecutionsPaginated(
                request: ListActionExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.ListActionExecutionsResponse.ReadOnly
            ] = proxy(ListActionExecutionsPaginated, request)
            def updatePipeline(request: UpdatePipelineRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly
            ] = proxy(UpdatePipeline, request)
            def startPipelineExecution(
                request: StartPipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly
            ] = proxy(StartPipelineExecution, request)
            def putJobSuccessResult(
                request: PutJobSuccessResultRequest
            ): IO[AwsError, Unit] = proxy(PutJobSuccessResult, request)
            def deleteWebhook(request: DeleteWebhookRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.DeleteWebhookResponse.ReadOnly
            ] = proxy(DeleteWebhook, request)
            def listActionTypes(request: ListActionTypesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codepipeline.model.ActionType.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListActionTypes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listActionTypesPaginated(request: ListActionTypesRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.ListActionTypesResponse.ReadOnly
            ] = proxy(ListActionTypesPaginated, request)
            def acknowledgeThirdPartyJob(
                request: AcknowledgeThirdPartyJobRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.AcknowledgeThirdPartyJobResponse.ReadOnly
            ] = proxy(AcknowledgeThirdPartyJob, request)
            def putJobFailureResult(
                request: PutJobFailureResultRequest
            ): IO[AwsError, Unit] = proxy(PutJobFailureResult, request)
            def listPipelines(request: ListPipelinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codepipeline.model.PipelineSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPipelines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPipelinesPaginated(request: ListPipelinesRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.ListPipelinesResponse.ReadOnly
            ] = proxy(ListPipelinesPaginated, request)
            def acknowledgeJob(request: AcknowledgeJobRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly
            ] = proxy(AcknowledgeJob, request)
            def listRuleTypes(request: ListRuleTypesRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.ListRuleTypesResponse.ReadOnly
            ] = proxy(ListRuleTypes, request)
            def updateActionType(
                request: UpdateActionTypeRequest
            ): IO[AwsError, Unit] = proxy(UpdateActionType, request)
            def putApprovalResult(request: PutApprovalResultRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly
            ] = proxy(PutApprovalResult, request)
            def getPipelineState(request: GetPipelineStateRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.GetPipelineStateResponse.ReadOnly
            ] = proxy(GetPipelineState, request)
            def pollForJobs(request: PollForJobsRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.PollForJobsResponse.ReadOnly
            ] = proxy(PollForJobs, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createCustomActionType(
                request: CreateCustomActionTypeRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly
            ] = proxy(CreateCustomActionType, request)
            def pollForThirdPartyJobs(
                request: PollForThirdPartyJobsRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.PollForThirdPartyJobsResponse.ReadOnly
            ] = proxy(PollForThirdPartyJobs, request)
            def putThirdPartyJobFailureResult(
                request: PutThirdPartyJobFailureResultRequest
            ): IO[AwsError, Unit] =
              proxy(PutThirdPartyJobFailureResult, request)
            def putWebhook(request: PutWebhookRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.PutWebhookResponse.ReadOnly
            ] = proxy(PutWebhook, request)
            def deletePipeline(
                request: DeletePipelineRequest
            ): IO[AwsError, Unit] = proxy(DeletePipeline, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.codepipeline.model.Tag.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTagsForResource, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def disableStageTransition(
                request: DisableStageTransitionRequest
            ): IO[AwsError, Unit] = proxy(DisableStageTransition, request)
            def deleteCustomActionType(
                request: DeleteCustomActionTypeRequest
            ): IO[AwsError, Unit] = proxy(DeleteCustomActionType, request)
            def putThirdPartyJobSuccessResult(
                request: PutThirdPartyJobSuccessResultRequest
            ): IO[AwsError, Unit] =
              proxy(PutThirdPartyJobSuccessResult, request)
            def getActionType(request: GetActionTypeRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.GetActionTypeResponse.ReadOnly
            ] = proxy(GetActionType, request)
            def stopPipelineExecution(
                request: StopPipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly
            ] = proxy(StopPipelineExecution, request)
            def rollbackStage(request: RollbackStageRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.RollbackStageResponse.ReadOnly
            ] = proxy(RollbackStage, request)
            def deregisterWebhookWithThirdParty(
                request: DeregisterWebhookWithThirdPartyRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.DeregisterWebhookWithThirdPartyResponse.ReadOnly
            ] = proxy(DeregisterWebhookWithThirdParty, request)
            def registerWebhookWithThirdParty(
                request: RegisterWebhookWithThirdPartyRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.RegisterWebhookWithThirdPartyResponse.ReadOnly
            ] = proxy(RegisterWebhookWithThirdParty, request)
            def createPipeline(request: CreatePipelineRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly
            ] = proxy(CreatePipeline, request)
            def enableStageTransition(
                request: EnableStageTransitionRequest
            ): IO[AwsError, Unit] = proxy(EnableStageTransition, request)
            def getJobDetails(request: GetJobDetailsRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.GetJobDetailsResponse.ReadOnly
            ] = proxy(GetJobDetails, request)
            def getThirdPartyJobDetails(
                request: GetThirdPartyJobDetailsRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.GetThirdPartyJobDetailsResponse.ReadOnly
            ] = proxy(GetThirdPartyJobDetails, request)
            def putActionRevision(request: PutActionRevisionRequest): IO[
              AwsError,
              zio.aws.codepipeline.model.PutActionRevisionResponse.ReadOnly
            ] = proxy(PutActionRevision, request)
            def getPipelineExecution(
                request: GetPipelineExecutionRequest
            ): IO[AwsError, ReadOnly] = proxy(GetPipelineExecution, request)
            def listRuleExecutions(request: ListRuleExecutionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codepipeline.model.RuleExecutionDetail.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRuleExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRuleExecutionsPaginated(
                request: ListRuleExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.codepipeline.model.ListRuleExecutionsResponse.ReadOnly
            ] = proxy(ListRuleExecutionsPaginated, request)
            def overrideStageCondition(
                request: OverrideStageConditionRequest
            ): IO[AwsError, Unit] = proxy(OverrideStageCondition, request)
          }
        }
      }
    }
  }
}
