package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  ActionConfigurationKey,
  ActionRunOrder,
  ActionNamespace,
  RoleArn,
  ActionName,
  ActionConfigurationValue,
  OutputVariable,
  Command,
  ActionTimeout,
  AWSRegionName
}
import scala.jdk.CollectionConverters.*
final case class ActionDeclaration(
    name: ActionName,
    actionTypeId: zio.aws.codepipeline.model.ActionTypeId,
    runOrder: Optional[ActionRunOrder] = Optional.Absent,
    configuration: Optional[
      Map[ActionConfigurationKey, ActionConfigurationValue]
    ] = Optional.Absent,
    commands: Optional[Iterable[Command]] = Optional.Absent,
    outputArtifacts: Optional[
      Iterable[zio.aws.codepipeline.model.OutputArtifact]
    ] = Optional.Absent,
    inputArtifacts: Optional[
      Iterable[zio.aws.codepipeline.model.InputArtifact]
    ] = Optional.Absent,
    outputVariables: Optional[Iterable[OutputVariable]] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    region: Optional[AWSRegionName] = Optional.Absent,
    namespace: Optional[ActionNamespace] = Optional.Absent,
    timeoutInMinutes: Optional[ActionTimeout] = Optional.Absent,
    environmentVariables: Optional[
      Iterable[zio.aws.codepipeline.model.EnvironmentVariable]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionDeclaration = {
    import ActionDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
      .builder()
      .name(ActionName.unwrap(name): java.lang.String)
      .actionTypeId(actionTypeId.buildAwsValue())
      .optionallyWith(
        runOrder.map(value => ActionRunOrder.unwrap(value): Integer)
      )(_.runOrder)
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (ActionConfigurationKey.unwrap(
                key
              ): java.lang.String) -> (ActionConfigurationValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(
        commands.map(value =>
          value.map { item =>
            Command.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.commands)
      .optionallyWith(
        outputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputArtifacts)
      .optionallyWith(
        inputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputArtifacts)
      .optionallyWith(
        outputVariables.map(value =>
          value.map { item =>
            OutputVariable.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputVariables)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        region.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        namespace.map(value => ActionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        timeoutInMinutes.map(value => ActionTimeout.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        environmentVariables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVariables)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionDeclaration.ReadOnly =
    zio.aws.codepipeline.model.ActionDeclaration.wrap(buildAwsValue())
}
object ActionDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionDeclaration =
      zio.aws.codepipeline.model.ActionDeclaration(
        name,
        actionTypeId.asEditable,
        runOrder.map(value => value),
        configuration.map(value => value),
        commands.map(value => value),
        outputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputVariables.map(value => value),
        roleArn.map(value => value),
        region.map(value => value),
        namespace.map(value => value),
        timeoutInMinutes.map(value => value),
        environmentVariables.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ActionName
    def actionTypeId: zio.aws.codepipeline.model.ActionTypeId.ReadOnly
    def runOrder: Optional[ActionRunOrder]
    def configuration
        : Optional[Map[ActionConfigurationKey, ActionConfigurationValue]]
    def commands: Optional[List[Command]]
    def outputArtifacts
        : Optional[List[zio.aws.codepipeline.model.OutputArtifact.ReadOnly]]
    def inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.InputArtifact.ReadOnly]]
    def outputVariables: Optional[List[OutputVariable]]
    def roleArn: Optional[RoleArn]
    def region: Optional[AWSRegionName]
    def namespace: Optional[ActionNamespace]
    def timeoutInMinutes: Optional[ActionTimeout]
    def environmentVariables: Optional[
      List[zio.aws.codepipeline.model.EnvironmentVariable.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(name)
    def getActionTypeId
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      ZIO.succeed(actionTypeId)
    def getRunOrder: ZIO[Any, AwsError, ActionRunOrder] =
      AwsError.unwrapOptionField("runOrder", runOrder)
    def getConfiguration: ZIO[Any, AwsError, Map[
      ActionConfigurationKey,
      ActionConfigurationValue
    ]] = AwsError.unwrapOptionField("configuration", configuration)
    def getCommands: ZIO[Any, AwsError, List[Command]] =
      AwsError.unwrapOptionField("commands", commands)
    def getOutputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.OutputArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getInputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.InputArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getOutputVariables: ZIO[Any, AwsError, List[OutputVariable]] =
      AwsError.unwrapOptionField("outputVariables", outputVariables)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRegion: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("region", region)
    def getNamespace: ZIO[Any, AwsError, ActionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getTimeoutInMinutes: ZIO[Any, AwsError, ActionTimeout] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getEnvironmentVariables: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.EnvironmentVariable.ReadOnly
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
  ) extends zio.aws.codepipeline.model.ActionDeclaration.ReadOnly {
    override val name: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.name())
    override val actionTypeId
        : zio.aws.codepipeline.model.ActionTypeId.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeId.wrap(impl.actionTypeId())
    override val runOrder: Optional[ActionRunOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.runOrder())
      .map(value => zio.aws.codepipeline.model.primitives.ActionRunOrder(value))
    override val configuration
        : Optional[Map[ActionConfigurationKey, ActionConfigurationValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codepipeline.model.primitives.ActionConfigurationKey(
                key
              ) -> zio.aws.codepipeline.model.primitives
                .ActionConfigurationValue(value)
            })
            .toMap
        )
    override val commands: Optional[List[Command]] = zio.aws.core.internal
      .optionalFromNullable(impl.commands())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.primitives.Command(item)
        }.toList
      )
    override val outputArtifacts
        : Optional[List[zio.aws.codepipeline.model.OutputArtifact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.OutputArtifact.wrap(item)
          }.toList
        )
    override val inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.InputArtifact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.InputArtifact.wrap(item)
          }.toList
        )
    override val outputVariables: Optional[List[OutputVariable]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputVariables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.OutputVariable(item)
          }.toList
        )
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.codepipeline.model.primitives.RoleArn(value))
    override val region: Optional[AWSRegionName] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
    override val namespace: Optional[ActionNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ActionNamespace(value)
      )
    override val timeoutInMinutes: Optional[ActionTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInMinutes())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ActionTimeout(value)
        )
    override val environmentVariables: Optional[
      List[zio.aws.codepipeline.model.EnvironmentVariable.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentVariables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.EnvironmentVariable.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionDeclaration
  ): zio.aws.codepipeline.model.ActionDeclaration.ReadOnly = new Wrapper(impl)
}
