package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codepipeline.model.primitives.{Timestamp, ExecutionSummary}
import scala.jdk.CollectionConverters.*
final case class ConditionExecution(
    status: Optional[zio.aws.codepipeline.model.ConditionExecutionStatus] =
      Optional.Absent,
    summary: Optional[ExecutionSummary] = Optional.Absent,
    lastStatusChange: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ConditionExecution = {
    import ConditionExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ConditionExecution
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        summary.map(value => ExecutionSummary.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(
        lastStatusChange.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStatusChange)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ConditionExecution.ReadOnly =
    zio.aws.codepipeline.model.ConditionExecution.wrap(buildAwsValue())
}
object ConditionExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ConditionExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ConditionExecution =
      zio.aws.codepipeline.model.ConditionExecution(
        status.map(value => value),
        summary.map(value => value),
        lastStatusChange.map(value => value)
      )
    def status: Optional[zio.aws.codepipeline.model.ConditionExecutionStatus]
    def summary: Optional[ExecutionSummary]
    def lastStatusChange: Optional[Timestamp]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ConditionExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getSummary: ZIO[Any, AwsError, ExecutionSummary] =
      AwsError.unwrapOptionField("summary", summary)
    def getLastStatusChange: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ConditionExecution
  ) extends zio.aws.codepipeline.model.ConditionExecution.ReadOnly {
    override val status
        : Optional[zio.aws.codepipeline.model.ConditionExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codepipeline.model.ConditionExecutionStatus.wrap(value)
        )
    override val summary: Optional[ExecutionSummary] = zio.aws.core.internal
      .optionalFromNullable(impl.summary())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ExecutionSummary(value)
      )
    override val lastStatusChange: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusChange())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ConditionExecution
  ): zio.aws.codepipeline.model.ConditionExecution.ReadOnly = new Wrapper(impl)
}
