package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  EnvironmentVariableValue,
  EnvironmentVariableName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnvironmentVariable(
    name: EnvironmentVariableName,
    value: EnvironmentVariableValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.EnvironmentVariable = {
    import EnvironmentVariable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.EnvironmentVariable
      .builder()
      .name(EnvironmentVariableName.unwrap(name): java.lang.String)
      .value(EnvironmentVariableValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.EnvironmentVariable.ReadOnly =
    zio.aws.codepipeline.model.EnvironmentVariable.wrap(buildAwsValue())
}
object EnvironmentVariable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.EnvironmentVariable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.EnvironmentVariable =
      zio.aws.codepipeline.model.EnvironmentVariable(name, value)
    def name: EnvironmentVariableName
    def value: EnvironmentVariableValue
    def getName: ZIO[Any, Nothing, EnvironmentVariableName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, EnvironmentVariableValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.EnvironmentVariable
  ) extends zio.aws.codepipeline.model.EnvironmentVariable.ReadOnly {
    override val name: EnvironmentVariableName =
      zio.aws.codepipeline.model.primitives.EnvironmentVariableName(impl.name())
    override val value: EnvironmentVariableValue =
      zio.aws.codepipeline.model.primitives
        .EnvironmentVariableValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.EnvironmentVariable
  ): zio.aws.codepipeline.model.EnvironmentVariable.ReadOnly = new Wrapper(impl)
}
