package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ExecutionMode {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ExecutionMode
}
object ExecutionMode {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ExecutionMode
  ): zio.aws.codepipeline.model.ExecutionMode = value match {
    case software.amazon.awssdk.services.codepipeline.model.ExecutionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ExecutionMode.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.codepipeline.model.ExecutionMode.SUPERSEDED =>
      val r = SUPERSEDED
      r
    case software.amazon.awssdk.services.codepipeline.model.ExecutionMode.PARALLEL =>
      val r = PARALLEL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutionMode =
      software.amazon.awssdk.services.codepipeline.model.ExecutionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.codepipeline.model.ExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutionMode =
      software.amazon.awssdk.services.codepipeline.model.ExecutionMode.QUEUED
  }
  case object SUPERSEDED extends zio.aws.codepipeline.model.ExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutionMode =
      software.amazon.awssdk.services.codepipeline.model.ExecutionMode.SUPERSEDED
  }
  case object PARALLEL extends zio.aws.codepipeline.model.ExecutionMode {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ExecutionMode =
      software.amazon.awssdk.services.codepipeline.model.ExecutionMode.PARALLEL
  }
}
