package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.GitBranchNamePattern
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GitBranchFilterCriteria(
    includes: Optional[Iterable[GitBranchNamePattern]] = Optional.Absent,
    excludes: Optional[Iterable[GitBranchNamePattern]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GitBranchFilterCriteria = {
    import GitBranchFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GitBranchFilterCriteria
      .builder()
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            GitBranchNamePattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            GitBranchNamePattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludes)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.GitBranchFilterCriteria.ReadOnly =
    zio.aws.codepipeline.model.GitBranchFilterCriteria.wrap(buildAwsValue())
}
object GitBranchFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GitBranchFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GitBranchFilterCriteria =
      zio.aws.codepipeline.model.GitBranchFilterCriteria(
        includes.map(value => value),
        excludes.map(value => value)
      )
    def includes: Optional[List[GitBranchNamePattern]]
    def excludes: Optional[List[GitBranchNamePattern]]
    def getIncludes: ZIO[Any, AwsError, List[GitBranchNamePattern]] =
      AwsError.unwrapOptionField("includes", includes)
    def getExcludes: ZIO[Any, AwsError, List[GitBranchNamePattern]] =
      AwsError.unwrapOptionField("excludes", excludes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GitBranchFilterCriteria
  ) extends zio.aws.codepipeline.model.GitBranchFilterCriteria.ReadOnly {
    override val includes: Optional[List[GitBranchNamePattern]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.GitBranchNamePattern(item)
          }.toList
        )
    override val excludes: Optional[List[GitBranchNamePattern]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.GitBranchNamePattern(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GitBranchFilterCriteria
  ): zio.aws.codepipeline.model.GitBranchFilterCriteria.ReadOnly = new Wrapper(
    impl
  )
}
