package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.GitFilePathPattern
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GitFilePathFilterCriteria(
    includes: Optional[Iterable[GitFilePathPattern]] = Optional.Absent,
    excludes: Optional[Iterable[GitFilePathPattern]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GitFilePathFilterCriteria = {
    import GitFilePathFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GitFilePathFilterCriteria
      .builder()
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            GitFilePathPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            GitFilePathPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludes)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.GitFilePathFilterCriteria.ReadOnly =
    zio.aws.codepipeline.model.GitFilePathFilterCriteria.wrap(buildAwsValue())
}
object GitFilePathFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GitFilePathFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GitFilePathFilterCriteria =
      zio.aws.codepipeline.model.GitFilePathFilterCriteria(
        includes.map(value => value),
        excludes.map(value => value)
      )
    def includes: Optional[List[GitFilePathPattern]]
    def excludes: Optional[List[GitFilePathPattern]]
    def getIncludes: ZIO[Any, AwsError, List[GitFilePathPattern]] =
      AwsError.unwrapOptionField("includes", includes)
    def getExcludes: ZIO[Any, AwsError, List[GitFilePathPattern]] =
      AwsError.unwrapOptionField("excludes", excludes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GitFilePathFilterCriteria
  ) extends zio.aws.codepipeline.model.GitFilePathFilterCriteria.ReadOnly {
    override val includes: Optional[List[GitFilePathPattern]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.GitFilePathPattern(item)
          }.toList
        )
    override val excludes: Optional[List[GitFilePathPattern]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.primitives.GitFilePathPattern(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GitFilePathFilterCriteria
  ): zio.aws.codepipeline.model.GitFilePathFilterCriteria.ReadOnly =
    new Wrapper(impl)
}
